/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.IInstallerStage;
import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.LoggerUtils;
import com.palm.nova.installer.core.NullProgressReporter;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseStage
implements IInstallerStage {
    private IStageProgressReporter progress;

    public void setProgressHandler(IStageProgressReporter progress) {
        this.progress = progress;
    }

    public IStageProgressReporter getProgressHandler() {
        if (this.progress != null) {
            return this.progress;
        }
        return new NullProgressReporter();
    }

    @Override
    public abstract String toString();

    @Override
    public abstract void run() throws IOException, NovacomException;

    protected class StreamReaderThread
    extends Thread {
        INovacomStream stream;
        Object jobId;
        boolean stringFoundInJobOutput;
        String checkForThisStringInOutput;

        public StreamReaderThread(INovacomStream stream, Object jobId) {
            this(stream, jobId, null);
        }

        public StreamReaderThread(INovacomStream stream, Object jobId, String checkForThisStringInOutput) {
            this.stream = stream;
            this.jobId = jobId;
            this.stringFoundInJobOutput = false;
            this.checkForThisStringInOutput = checkForThisStringInOutput;
        }

        @Override
        public void run() {
            Logger logger = LoggerUtils.getInstance().getLogger("StreamReaderThread");
            try {
                String line;
                while ((line = this.stream.readLine()).compareTo("") != 0) {
                    if (null != this.checkForThisStringInOutput && -1 != line.indexOf(this.checkForThisStringInOutput)) {
                        this.stringFoundInJobOutput = true;
                    }
                    BaseStage.this.getProgressHandler().commentOnJob(this.jobId, line);
                    System.out.print(line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.log(Level.WARNING, "", e);
            }
        }

        boolean didWeFindTheStringWeWereLookingFor() {
            return this.stringFoundInJobOutput;
        }
    }
}

